<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license https://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreCruscotto extends VisualizzatoreComponente {
        private $idSessione;
        
        function __construct($db) {
            parent::__construct($db);
            
            $this->idSessione = $_SESSION['geecomUser_id'];
        }

        function generaContenutoSezione($dati) {
            $impostazioniForm         = parent::getDb()->leggiSingolaRiga("geec_cruscotti",$dati["idElemento"]);
            
            echo "<div class=\"{$impostazioniForm["spazioOccupato"]}\">";
?>
		<div class="row">
			<?php 
				$this->stampaElementi($dati);
			?>
		</div>
<?php
            echo"</div>";
        }
        
        function stampaElementi($dati) {
            $query = "SELECT * FROM geec_elementiCruscotto WHERE idCruscotto = {$dati["idElemento"]} ORDER BY posizione ASC";
            $ris   = parent::getDb()->eseguiQueryLettura($query);
            while($elemento = $ris->fetch_assoc()) {
		if($elemento["stile"]=="Aspetto 1") {
		    	$this->stampaSingoloElementoAspetto1($elemento);
		}
		else {
		    	$this->stampaSingoloElementoAspetto2($elemento);
		}
            }
        }
        
        function stampaSingoloElementoAspetto1($elemento) {
            	$valoreNumeratore = $this->determinaNumeratoreElemento($elemento);
		?>
		<div class="<?= $elemento["spazioOccupato"] ?>">
			<div class="widget card d-flex flex-row align-items-center box-shadow-lite bg-<?= strtolower($elemento["coloreSfondo"]) ?> text-<?= strtolower($elemento["coloreTesti"]) ?> <?= $elemento["classiAggiuntive"] ?>">
				<i class="<?= $elemento["icona"]?> fa-3x p-3"></i>
				<div class="text">
					<h6 class="mb-0"><?= $elemento["nome"] ?></h6>
					<h4 class="mb-0"><strong><?= $valoreNumeratore ?></strong></h4>
				</div>
				<a class="align-self-center ml-auto" href="<?= $elemento["linkPulsante1"] ?>"><i class="fas fa-arrow-right"></i></a>
			</div>
		</div>
		<?php                
        }

        function stampaSingoloElementoAspetto2($elemento) {
            	$valoreNumeratore = $this->determinaNumeratoreElemento($elemento);
		?>
		<div class="<?= $elemento["spazioOccupato"] ?>">
			<div class="widget card card-body bg-<?= strtolower($elemento["coloreSfondo"]) ?> text-<?= strtolower($elemento["coloreTesti"]) ?> <?= $elemento["classiAggiuntive"] ?>">
				<div class="d-flex justify-content-between">
					<i class="<?= $elemento["icona"]?> fa-3x p-3"></i>
					<div class="text text-right">
						<h6 class="mb-0"><?= $elemento["nome"] ?></h6>
						<h4 class="mb-0"><strong><?= $valoreNumeratore ?></strong></h4>
					</div>
				</div>
				<div class="form-row mt-3"> 
					<?php 
						if($elemento["etichettaPulsante1"]!="") {
						?>
							<div class="col"> 
								<a class="btn btn-<?= strtolower($elemento["stilePulsanti"]) ?> btn-block" href="<?= $elemento["linkPulsante1"] ?>"><?= $elemento["etichettaPulsante1"] ?></a>
							</div>
						<?php
						}
						
						if($elemento["etichettaPulsante2"]!="") {
						?>
							<div class="col"> 
								<a class="btn btn-<?= strtolower($elemento["stilePulsante2"]) ?> btn-block" href="<?= $elemento["linkPulsante2"] ?>"><?= $elemento["etichettaPulsante2"] ?></a>
							</div>
						<?php
						}
					?>
				</div>
			</div>
		</div>
		<?php                
        }     
        
        function determinaNumeratoreElemento($elemento) {
            if($elemento["valoreMostrato"]=="Genera con query") {                
        	$query = str_replace("{geecomUser_id}",$this->idSessione,$elemento["query"]);
        	error_log("posizione {geecomUser_id} nella query: ".strpos($elemento["query"],"{geecomUser_id}"));
            	$risNumeratoreElemento = parent::getDb()->eseguiQueryLettura($query);
            	
		return $risNumeratoreElemento->num_rows;
            }
            else {
		return $elemento["valoreDaMostrare"];                
            }
        }   
        
    }
